/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.gui.util.IComponentGui;
import noppes.npcs.client.gui.util.IEditNPC;
import noppes.npcs.client.gui.util.IGuiNpcLabel;
import noppes.npcs.util.Util;

public class GuiNpcLabel
implements IComponentGui,
IGuiNpcLabel {
    public boolean enabled = true;
    public boolean hovered;
    public int backColor = 0;
    public int borderColor = 0;
    public int height = 9;
    public int width = 0;
    public int color;
    public int id;
    public int x;
    public int y;
    public List<String> label;
    private final List<String> hoverText = new ArrayList<String>();

    public GuiNpcLabel(int id, Object label, int x, int y) {
        this(id, label, x, y, CustomNpcResourceListener.DefaultTextColor);
    }

    public GuiNpcLabel(int id, Object label, int x, int y, int color) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.color = color;
        this.setLabel(label.toString());
    }

    @Override
    public void setCenter(int width) {
        this.x += (width - this.width) / 2;
    }

    @Override
    public List<String> getLabels() {
        return this.label;
    }

    @Override
    public void render(IEditNPC gui, int mouseX, int mouseY, float partialTicks) {
        if (!this.enabled) {
            return;
        }
        boolean bl = this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        if (this.hovered && !this.hoverText.isEmpty()) {
            gui.setHoverText(this.hoverText);
        }
        if (this.label == null || this.label.isEmpty()) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.borderColor != 0) {
            Gui.func_73734_a((int)(this.x - 2), (int)(this.y - 1), (int)(this.x + this.width + 2), (int)(this.y + this.height), (int)this.borderColor);
        }
        if (this.backColor != 0) {
            Gui.func_73734_a((int)(this.x - 1), (int)this.y, (int)(this.x + this.width + 1), (int)(this.y + this.height - 1), (int)this.backColor);
        }
        int i = 0;
        for (String str : this.label) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(str, this.x, this.y + i, this.color);
            i += 10;
        }
    }

    @Override
    public void setLabel(Object labels) {
        Object str;
        if (labels == null) {
            this.label = null;
            this.height = 10;
            this.width = 0;
            return;
        }
        if (((Object)labels).toString().contains("\n")) {
            ArrayList<String> list = new ArrayList<String>();
            String text = ((Object)labels).toString();
            while (text.contains("\n")) {
                list.add(text.substring(0, text.indexOf("\n")));
                text = text.substring(text.indexOf("\n") + 1);
            }
            list.add(text);
            labels = list;
        }
        if (labels instanceof String[]) {
            labels = new ArrayList<String>(Arrays.asList((String[])labels));
        }
        if (labels instanceof List) {
            if (((List)labels).size() == 1) {
                str = ((List)labels).get(0) == null ? "" : new TextComponentTranslation(((Object)labels).toString(), new Object[0]).func_150254_d();
                this.label = Collections.singletonList(str);
                this.height = 10;
                this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(Util.instance.deleteColor((String)str));
                return;
            }
            this.label = new ArrayList<String>();
            this.height = 10 * ((List)labels).size();
            this.width = 0;
            for (Object obj : (List)labels) {
                String str2 = new TextComponentTranslation(obj.toString(), new Object[0]).func_150254_d();
                this.label.add(str2);
                int w = Minecraft.func_71410_x().field_71466_p.func_78256_a(Util.instance.deleteColor(str2));
                if (this.width >= w) continue;
                this.width = w;
            }
        } else {
            str = ((Object)labels).toString();
            try {
                str = new TextComponentTranslation(((Object)labels).toString(), new Object[0]).func_150254_d();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.label = Collections.singletonList(str);
            this.height = 10;
            this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(Util.instance.deleteColor((String)str));
        }
    }

    @Override
    public void setBackColor(int color) {
        this.backColor = color;
    }

    @Override
    public int getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setBorderColor(int color) {
        this.borderColor = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getBackColor() {
        return this.backColor;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int[] getCenter() {
        return new int[]{this.x + this.width / 2, this.y + this.height / 2};
    }

    @Override
    public void setHoverText(String text, Object ... args) {
        this.hoverText.clear();
        if (text == null || text.isEmpty()) {
            return;
        }
        if (!text.contains("%")) {
            text = new TextComponentTranslation(text, args).func_150254_d();
        }
        if (text.contains("~~~")) {
            text = text.replaceAll("~~~", "%");
        }
        while (text.contains("<br>")) {
            this.hoverText.add(text.substring(0, text.indexOf("<br>")));
            text = text.substring(text.indexOf("<br>") + 4);
        }
        this.hoverText.add(text);
    }

    @Override
    public int getLeft() {
        return this.x;
    }

    @Override
    public int getTop() {
        return this.y;
    }

    @Override
    public void setLeft(int left) {
        this.x = left;
    }

    @Override
    public void setTop(int top) {
        this.y = top;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void customKeyTyped(char c, int id) {
    }

    @Override
    public void customMouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void customMouseReleased(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public boolean isVisible() {
        return this.enabled;
    }

    @Override
    public void setIsVisible(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }
}

